/*
* Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* SPDX-License-Identifier:	GPL-2.0+
*/

#ifndef COCOA_RTOS_PART_NAME
#error Need to define RTOS image partition name
#endif

#ifndef COCOA_RTOS_BACKUP_PART_NAME
#error Need to define RTOS backup image partition name
#endif

#ifndef COCOA_RTOS_SIZE
#error Need to define RTOS image size in COCOA_RTOS_SIZE
#endif

#ifndef COCOA_RTOS_BOOT_ADDRESS
#error Need to define the RTOS boot address
#endif

#if !defined(COCOA_BLUE_SIGNATURE_VERIFICATION_PSS) || !defined(COCOA_BLUE_SIGNATURE_VERIFICATION_PKCS)
#error Need to define RSA padding mode
#endif

#if (COCOA_BLUE_SIGNATURE_VERIFICATION_PSS == COCOA_BLUE_SIGNATURE_VERIFICATION_PKCS)
#error Only one RSA padding mode can be active
#endif

#define COCOA_NEXT_STAGE_PART_NAME COCOA_RTOS_PART_NAME
#define COCOA_NEXT_STAGE_BACKUP_PART_NAME COCOA_RTOS_BACKUP_PART_NAME
#define COCOA_NEXT_STAGE_PART_SIZE COCOA_RTOS_SIZE
#define COCOA_NEXT_STAGE_BOOT_ADDRESS COCOA_RTOS_BOOT_ADDRESS

#define COCOA_NEXT_STAGE_PROD_KEY PROD_RTOS_PUB
#define COCOA_NEXT_STAGE_DEV_KEY  DEV_RTOS_PUB

#define get_ns_header_size() (sizeof(rtk_image_header_t))
#define get_ns_image_size(hdr) ((rtk_image_header_t *)hdr)->size
